/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import jgamebase.Const;
import jgamebase.tools.FileTools;

public class TempDir
implements AutoCloseable {
    private static final File globalTempDir = new File(System.getProperty("java.io.tmpdir"), Const.NAME_JGAMEBASE_LC);
    protected final File tempDir = Files.createTempDirectory(String.valueOf(Const.NAME_JGAMEBASE_LC) + "_", new FileAttribute[0]).toFile();

    public static void cleanPath() {
        FileTools.deleteAll(globalTempDir);
        globalTempDir.delete();
    }

    public static File getPath() {
        if (!globalTempDir.exists()) {
            globalTempDir.mkdirs();
        }
        return globalTempDir;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.tempDir != null) {
            FileTools.deleteAll(this.tempDir);
            this.tempDir.delete();
        }
    }

    public String toString() {
        return this.tempDir.getAbsolutePath();
    }
}

